sbit       NumLock_LED    =    P3^5;
sbit       Caps_LED       =    P3^6;
sbit       ScrollLock_LED =    P3^7;

#define    MAX_COLUMN          0x12
#define    MAX_ROW             0x08

#define    L_CTRL              0xE0
#define    L_SHIFT             0xE1
#define    L_ALT               0xE2
#define    L_GUI               0xE3
#define    R_CTRL              0xE4
#define    R_SHIFT             0xE5
#define    R_ALT               0xE6
#define    R_GUI               0xE7


typedef struct
   { BYTE Column;
     BYTE Code;
     BYTE Tmp;
     BYTE Store[MAX_COLUMN];
   } SCAN;


typedef struct
   { BYTE Busy;
     BYTE IdleRate;
     BYTE Protocol;
     BYTE Index;
     BYTE Code;
     BYTE GhostFlag;
     BYTE ChangeFlag;
   } KEY;


typedef struct
   { BYTE LeftCtrl : 1;
     BYTE LeftShift : 1;
     BYTE LeftAlt : 1;
     BYTE LeftGui : 1;
     BYTE RightCtrl : 1;
     BYTE RightShift : 1;
     BYTE RightAlt : 1;
     BYTE RightGui : 1;
   } MODIFIER;


typedef struct
   { MODIFIER Modifier;
     BYTE Reserve;
     BYTE Code[6];
   } PART;


typedef union	// allow bit or byte access to registers 
   { PART Part;
     BYTE Code[8];
   } TOHOST;


typedef struct
   { BYTE Act;
     SCAN Scan;
     KEY Key;
     BYTE HostIndex;
     TOHOST ToHost;
     BYTE i;
     BYTE Tmp;
   } KEYBOARD;